#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <stdlib.h>
#include "Common/GMLuaModule.h"

// blarg
#include "tokenreader.h"
#include "vmf.h"

// setup our module.
GMOD_MODULE( Init, Shutdown );


// metatables
enum
{
	TYPE_TOKENREADER	=	2002,
	TYPE_VMF			=	2003,
	TYPE_VMFENTITY		=	2004,

};



// Utility
////////////////////////////////////////////////////////////////////////////////
const char* RelativePathToFull( const char* filename )
{
	// call util.RelativePathToFull.
	ILuaObject* util = g_Lua->GetGlobal( "util" );
	ILuaObject* relativePathToFull = util->GetMember( "RelativePathToFull" );

	// Push the function we're going to call.
	relativePathToFull->Push();

	// pusht he file we want to get the full path to.
	g_Lua->Push( filename );

	// call function.
	g_Lua->Call( 1, 1 );		// 1 argument, 1 return value.

	// Get the filename.
	ILuaObject* fullPath = g_Lua->GetReturn( 0 );

	//
	return fullPath->GetString();

}
////////////////////////////////////////////////////////////////////////////////




// File Functions
////////////////////////////////////////////////////////////////////////////////

// Read file
LUA_FUNCTION( File_Read )
{
	// open file for reading
	HANDLE hnd = CreateFile(
			RelativePathToFull( g_Lua->GetString( 1 ) ),
			GENERIC_READ,
			FILE_SHARE_READ,
			NULL,
			OPEN_ALWAYS,
			FILE_ATTRIBUTE_NORMAL,
			NULL
	);

	// oh shi!?
	if( hnd == INVALID_HANDLE_VALUE )
	{
		return 0;

	}

	// read
	DWORD size = GetFileSize( hnd, NULL );
	char* buffer = new char[ size + 1 ];
	DWORD read;
	ReadFile(
			hnd,
			buffer,
			size,
			&read,
			NULL
	);

	// add terminator and push
	buffer[ read ] = '\0';		// Just in case...
	g_Lua->Push( buffer );

	// cleanup
	delete buffer;
	CloseHandle( hnd );

	//
	return 1;

}


// write
LUA_FUNCTION( File_Write )
{
	// open file for writing
	HANDLE hnd = CreateFile(
			RelativePathToFull( g_Lua->GetString( 1 ) ),
			GENERIC_WRITE,
			FILE_SHARE_WRITE,
			NULL,
			CREATE_NEW,
			FILE_ATTRIBUTE_NORMAL,
			NULL
	);

	// oh shi!?
	if( hnd == INVALID_HANDLE_VALUE )
	{
		return 0;

	}

	// write
	const char* buffer = g_Lua->GetString( 2 );
	DWORD size = (DWORD)strlen( buffer );
	DWORD wrote;
	WriteFile(
		hnd,
		buffer,
		size,
		&wrote,
		NULL
	);

	// cleanup
	CloseHandle( hnd );

	//
	return 0;

}
////////////////////////////////////////////////////////////////////////////////




// TokenReader
////////////////////////////////////////////////////////////////////////////////
LUA_FUNCTION( TokenReader_Create )
{
	// create a tokenreader.
	TokenReader* reader = new TokenReader( (char*)g_Lua->GetString( 1 ) );

	// push it onto the stack.
	ILuaObject* meta = g_Lua->GetMetaTable( "TokenReader", TYPE_TOKENREADER );
	g_Lua->PushUserData( meta, reader );
	SAFE_UNREF( meta );

	//
	return 1;

}

LUA_FUNCTION( TokenReader_Cleanup )
{
	// get the tokenreader.
	TokenReader* reader = (TokenReader*)g_Lua->GetUserData( 1 );

	// delete it
	if( reader )
	{
		delete reader;

	}

	// Wha!?
#if 0
	MessageBox( NULL, "Deleting TokenReader object.", "__gc", MB_ICONINFORMATION | MB_OK );

#endif

	//
	return 0;

}

LUA_FUNCTION( TokenReader_ReadToken )
{
	// get the tokenreader.
	TokenReader* reader = (TokenReader*)g_Lua->GetUserData( 1 );

	// fetch a token.
	char buffer[ 2049 ];
	float token = (float)reader->ReadToken( buffer, 2048 );

	// return
	g_Lua->Push( token );
	g_Lua->Push( buffer );

	//
	return 2;

}


////////////////////////////////////////////////////////////////////////////////





// VMF
////////////////////////////////////////////////////////////////////////////////
LUA_FUNCTION( VMF_Create )
{
	// create a vmf.
	VMF* vmf = new VMF();

	// push it onto the stack.
	ILuaObject* meta = g_Lua->GetMetaTable( "VMF", TYPE_VMF );
	g_Lua->PushUserData( meta, vmf );
	SAFE_UNREF( meta );

	//
	return 1;

}

LUA_FUNCTION( VMF_Parse )
{
	// get the vmf.
	VMF* vmf = (VMF*)g_Lua->GetUserData( 1 );

	// parse
	vmf->Parse( (char*)g_Lua->GetString( 2 ) );

	//
	return 0;

}

LUA_FUNCTION( VMF_Cleanup )
{
	// get the vmf.
	VMF* vmf = (VMF*)g_Lua->GetUserData( 1 );

	// Wha!?
#if 0
	MessageBox( NULL, "Deleting VMF object.", "__gc", MB_ICONINFORMATION | MB_OK );

#endif

	// delete it
	if( vmf )
	{
		delete vmf;

	}

	//
	return 0;

}

LUA_FUNCTION( VMF_Rename )
{
	// get the vmf.
	VMF* vmf = (VMF*)g_Lua->GetUserData( 1 );

	// call rename
	vmf->Rename( g_Lua->GetInteger( 2 ) );

	//
	return 0;

}

LUA_FUNCTION( VMF_CreateEntity )
{
	// get the vmf.
	VMF* vmf = (VMF*)g_Lua->GetUserData( 1 );

	// create a new entity and add.
	entity* ent = new entity;
	strcpy( ent->classname, g_Lua->GetString( 2 ) );
	ent->id = g_Lua->GetInteger( 3 );

	// add
	vmf->entities.push_back( ent );

	// push entity.
	ILuaObject* meta = g_Lua->GetMetaTable( "VMFEntity", TYPE_VMFENTITY );
	g_Lua->PushUserData( meta, ent );
	SAFE_UNREF( meta );

	//
	return 1;

}

LUA_FUNCTION( VMF_Entity )
{
	// get the vmf.
	VMF* vmf = (VMF*)g_Lua->GetUserData( 1 );

	// fetch
	entity* ent = vmf->entities[ g_Lua->GetInteger( 2 ) ];

	// push entity.
	ILuaObject* meta = g_Lua->GetMetaTable( "VMFEntity", TYPE_VMFENTITY );
	g_Lua->PushUserData( meta, ent );
	SAFE_UNREF( meta );

	//
	return 1;

}

LUA_FUNCTION( VMF_EntityCount )
{
	// get the vmf.
	VMF* vmf = (VMF*)g_Lua->GetUserData( 1 );

	// push count
	g_Lua->Push( (float)vmf->entities.size() );

	//
	return 1;

}

LUA_FUNCTION( VMF_WorldKey )
{
	// get the vmf.
	VMF* vmf = (VMF*)g_Lua->GetUserData( 1 );

	// fetch
	int idx = g_Lua->GetInteger( 2 );
	g_Lua->Push( vmf->worldkeys[ idx ].key );
	g_Lua->Push( vmf->worldkeys[ idx ].value );

	//
	return 2;

}

LUA_FUNCTION( VMF_WorldKeyCount )
{
	// get the vmf.
	VMF* vmf = (VMF*)g_Lua->GetUserData( 1 );

	// fetch
	g_Lua->Push( (float)vmf->worldkeys.size() );

	//
	return 1;

}

LUA_FUNCTION( VMF_FindByClass )
{
	// get the vmf.
	VMF* vmf = (VMF*)g_Lua->GetUserData( 1 );

	// fetch
	entity* ent = vmf->FindEntityByClass( (char*)g_Lua->GetString( 2 ) );

	// push entity.
	if( ent )
	{
		ILuaObject* meta = g_Lua->GetMetaTable( "VMFEntity", TYPE_VMFENTITY );
		g_Lua->PushUserData( meta, ent );
		SAFE_UNREF( meta );
		return 1;

	}


	//
	return 0;

}

LUA_FUNCTION( VMF_FindByName )
{
	// get the vmf.
	VMF* vmf = (VMF*)g_Lua->GetUserData( 1 );

	// fetch
	entity* ent = vmf->FindEntityByName( (char*)g_Lua->GetString( 2 ) );

	// push entity.
	if( ent )
	{
		ILuaObject* meta = g_Lua->GetMetaTable( "VMFEntity", TYPE_VMFENTITY );
		g_Lua->PushUserData( meta, ent );
		SAFE_UNREF( meta );
		return 1;

	}


	//
	return 0;

}

LUA_FUNCTION( VMF_FindByID )
{
	// get the vmf.
	VMF* vmf = (VMF*)g_Lua->GetUserData( 1 );

	// fetch
	entity* ent = vmf->FindEntityByID( g_Lua->GetInteger( 2 ) );

	// push entity.
	if( ent )
	{
		ILuaObject* meta = g_Lua->GetMetaTable( "VMFEntity", TYPE_VMFENTITY );
		g_Lua->PushUserData( meta, ent );
		SAFE_UNREF( meta );
		return 1;

	}


	//
	return 0;

}

LUA_FUNCTION( VMF_FindWorldKey )
{
	// get the vmf.
	VMF* vmf = (VMF*)g_Lua->GetUserData( 1 );

	// fetch the key we want to find.
	const char* key = g_Lua->GetString( 2 );

	// find it.
	for( int i = 0; i < (int)vmf->worldkeys.size(); i++ )
	{
		// compare
		if( strcmp( vmf->worldkeys[i].key, key ) == 0 )
		{
			// push it.
			g_Lua->Push( key );
			g_Lua->Push( vmf->worldkeys[i].value );
			return 2;

		}

	}

	//
	return 0;

}

////////////////////////////////////////////////////////////////////////////////

// VMFEntity
////////////////////////////////////////////////////////////////////////////////
LUA_FUNCTION( VMFEntity_Cleanup )
{
	// get the entity.
	entity* ent = (entity*)g_Lua->GetUserData( 1 );

	// delete it
	if( ent )
	{
		delete ent;

	}

	//
	return 0;

}

LUA_FUNCTION( VMFEntity_Key )
{
	// get the entity.
	entity* ent = (entity*)g_Lua->GetUserData( 1 );

	// fetch
	int idx = g_Lua->GetInteger( 2 );
	g_Lua->Push( ent->keyvalues[ idx ].key );
	g_Lua->Push( ent->keyvalues[ idx ].value );

	//
	return 2;

}

LUA_FUNCTION( VMFEntity_KeyCount )
{
	// get the entity.
	entity* ent = (entity*)g_Lua->GetUserData( 1 );

	// fetch
	g_Lua->Push( (float)ent->keyvalues.size() );

	//
	return 1;

}

LUA_FUNCTION( VMFEntity_Connection )
{
	// get the entity.
	entity* ent = (entity*)g_Lua->GetUserData( 1 );

	// fetch
	int idx = g_Lua->GetInteger( 2 );

	// go ahead and concatenate it.
	char buffer[128];
	sprintf( buffer, "%s %s,%s", ent->connections[ idx ].output, ent->connections[ idx ].targetname, ent->connections[ idx ].fire );
	g_Lua->Push( buffer );

	//
	return 1;

}

LUA_FUNCTION( VMFEntity_ConnectionCount )
{
	// get the entity.
	entity* ent = (entity*)g_Lua->GetUserData( 1 );

	// fetch
	g_Lua->Push( (float)ent->connections.size() );

	//
	return 1;

}

LUA_FUNCTION( VMFEntity_Class )
{
	// get the entity.
	entity* ent = (entity*)g_Lua->GetUserData( 1 );

	// fetch
	g_Lua->Push( ent->classname );

	//
	return 1;

}

LUA_FUNCTION( VMFEntity_ID )
{
	// get the entity.
	entity* ent = (entity*)g_Lua->GetUserData( 1 );

	// fetch
	g_Lua->Push( (float)ent->id );

	//
	return 1;

}

LUA_FUNCTION( VMFEntity_AddKey )
{
	// get the entity.
	entity* ent = (entity*)g_Lua->GetUserData( 1 );

	// create
	keyvalue kv;
	strcpy( kv.key, g_Lua->GetString( 2 ) );
	strcpy( kv.value, g_Lua->GetString( 3 ) );

	// add
	ent->keyvalues.push_back( kv );

	//
	return 0;

}

LUA_FUNCTION( VMFEntity_AddConnection )
{
	// get the entity.
	entity* ent = (entity*)g_Lua->GetUserData( 1 );

	// create
	connection conn;
	strcpy( conn.output, g_Lua->GetString( 2 ) );

	
	// split targetname.
	const char* buffer = g_Lua->GetString( 3 );
	char* fnd = strchr( buffer, ',' );

	// targetname.
	strncpy( conn.targetname, buffer, fnd - buffer );
	conn.targetname[ fnd - buffer ] = '\0';

	// fire
	strcpy( conn.fire, fnd + 1 );


	// add
	ent->connections.push_back( conn );

	//
	return 0;

}

LUA_FUNCTION( VMFEntity_FindKey )
{
	// get the entity.
	entity* ent = (entity*)g_Lua->GetUserData( 1 );

	// fetch the key we want to find.
	const char* key = g_Lua->GetString( 2 );

	// find it.
	for( int i = 0; i < (int)ent->keyvalues.size(); i++ )
	{
		// compare
		if( strcmp( ent->keyvalues[i].key, key ) == 0 )
		{
			// push it.
			g_Lua->Push( key );
			g_Lua->Push( ent->keyvalues[i].value );
			return 2;

		}

	}

	//
	return 0;

}

////////////////////////////////////////////////////////////////////////////////


// module init.
int Init( )
{
	// File methods.
	ILuaObject* VMFSuite = g_Lua->GetGlobal( "VMFSuite" );

	// add
	VMFSuite->SetMember( "ReadFile", File_Read );
	VMFSuite->SetMember( "WriteFile", File_Write );
	VMFSuite->SetMember( "TokenReader", TokenReader_Create );
	VMFSuite->SetMember( "VMF", VMF_Create );

	// release
	SAFE_UNREF( VMFSuite );





	// globals
	g_Lua->SetGlobal( "TOKEN_ERROR", (float)TOKEN_ERROR );
	g_Lua->SetGlobal( "TOKEN_NONE", (float)TOKEN_NONE );
	g_Lua->SetGlobal( "TOKEN_EOF", (float)TOKEN_EOF );
	g_Lua->SetGlobal( "TOKEN_OPERATOR", (float)TOKEN_OPERATOR );
	g_Lua->SetGlobal( "TOKEN_NUMBER", (float)TOKEN_NUMBER );
	g_Lua->SetGlobal( "TOKEN_STRING", (float)TOKEN_STRING );
	g_Lua->SetGlobal( "TOKEN_IDENTIFIER", (float)TOKEN_IDENTIFIER );
	g_Lua->SetGlobal( "TOKEN_COMMENT", (float)TOKEN_COMMENT );




	// Create tokenreader metatable.
	ILuaObject* TokenReader_meta = g_Lua->GetMetaTable( "TokenReader", TYPE_TOKENREADER );
	
	// setup __gc
	TokenReader_meta->SetMember( "__gc", TokenReader_Cleanup );
	TokenReader_meta->SetMember( "__index", TokenReader_meta );

	// setup methods.
	TokenReader_meta->SetMember( "ReadToken", TokenReader_ReadToken );

	// release.
	SAFE_UNREF( TokenReader_meta );





	// Create VMF metatable.
	ILuaObject* VMFEntity_meta = g_Lua->GetMetaTable( "VMFEntity", TYPE_VMFENTITY );
	
	// setup __gc
//	VMFEntity_meta->SetMember( "__gc", VMFEntity_Cleanup );
	VMFEntity_meta->SetMember( "__index", VMFEntity_meta );

	// methods.
	VMFEntity_meta->SetMember( "Key", VMFEntity_Key );
	VMFEntity_meta->SetMember( "KeyCount", VMFEntity_KeyCount );
	VMFEntity_meta->SetMember( "Connection", VMFEntity_Connection );
	VMFEntity_meta->SetMember( "ConnectionCount", VMFEntity_ConnectionCount );
	VMFEntity_meta->SetMember( "Class", VMFEntity_Class );
	VMFEntity_meta->SetMember( "ID", VMFEntity_ID );
	VMFEntity_meta->SetMember( "AddKey", VMFEntity_AddKey );
	VMFEntity_meta->SetMember( "AddConnection", VMFEntity_AddConnection );
	VMFEntity_meta->SetMember( "FindKey", VMFEntity_FindKey );

	// release.
	SAFE_UNREF( VMFEntity_meta );





	// Create VMF metatable.
	ILuaObject* VMF_meta = g_Lua->GetMetaTable( "VMF", TYPE_VMF );
	
	// setup __gc
	VMF_meta->SetMember( "__gc", VMF_Cleanup );
	VMF_meta->SetMember( "__index", VMF_meta );

	// setup methods.
	VMF_meta->SetMember( "Parse", VMF_Parse );
	VMF_meta->SetMember( "CreateEntity", VMF_CreateEntity );
	VMF_meta->SetMember( "Rename", VMF_Rename );
	VMF_meta->SetMember( "Entity", VMF_Entity );
	VMF_meta->SetMember( "EntityCount", VMF_EntityCount );
	VMF_meta->SetMember( "WorldKey", VMF_WorldKey );
	VMF_meta->SetMember( "FindWorldKey", VMF_FindWorldKey );
	VMF_meta->SetMember( "WorldKeyCount", VMF_WorldKeyCount );
	VMF_meta->SetMember( "FindByClass", VMF_FindByClass );
	VMF_meta->SetMember( "FindByName", VMF_FindByName );
	VMF_meta->SetMember( "FindByID", VMF_FindByID );
//	VMF_meta->SetMember( "Save", VMF_Save );

	// release.
	SAFE_UNREF( VMF_meta );







	return 0;
}

// module shutdown.
int Shutdown( )
{
	return 0;

}

